

module.exports = {

    getListPermissionByUser: async function (user) {

        /*let rolesPermission = await Rolespermission.find(
            {
                where: {'idRole': user.idRole},
                select: ['idPermission', 'canRead']
            }
          ).populate('idPermission')
        */

        //Carrega a lista de permissão do banco de dados de acordo com a Role do Usuário
        let rolesPermissionServer = await Rolespermission.find({
            'idRole': user.idRole
        }).populate('idPermission');

        let rolesPermissionList = [];

        //Prepara uma lista contendo o Path da permissão e as permissões CRUD, trocando 1 por true e 0 por false
        for (const item of rolesPermissionServer) {
            rolesPermissionList.push({
                path: item.idPermission.path,
                canAccess: item.canAccess == 1 ? true : false,
                canCreate: item.canCreate == 1 ? true : false,
                canRead: item.canRead == 1 ? true : false,
                canUpdate: item.canUpdate == 1 ? true : false,
                canDelete: item.canDelete == 1 ? true : false,
            })
        }
        return rolesPermissionList;


    },

    canPermissionToAcessRoute: async function (user, method, route) {

        //Cortar apenas a parte da definição da rota, retirar os parâmentros da rota, tipo /user/1, ficar apenas /user
        route = route.substring(0,route.indexOf('/', 1));
        
        //Carrega o usuário do banco de dados, para carregar os dados que não estão no token.
        let userCurrent = await User.findOne({ id: user.id });

        //Busca o id da Permissão através da rota
        let getPermission = await Permission.findOne({ path: route });

        //Se não houver rota registrada nas permissões, enviará uma mensagem de erro
        if (getPermission == undefined) {
            return JSON.stringify({ status: 403, message: 'Rota não cadastrada nas permissões!' });
        }
        //sails.log('id Permission: '+getPermission.id);

        //Busca a lista de Permissões da rota específica
        let permissions = await Rolespermission.find({
            'idRole': userCurrent.idRole,
            'idPermission': getPermission.id
        })

        //Se não encontrar o resultado da pesquisa pela rota e permissão informada, enviará uma mensagem de erro
        if (permissions[0] == undefined) {
            return JSON.stringify({ status: 403, message: 'Rota não cadastrada nas permissões!' });
        } else {
            permissions = permissions[0];
        }
        // sails.log(method.localeCompare('GET'))
        //sails.log(permissions)

        //Verificar as permissões de acordo com o Método enviado GET/POST/PUT ou PATCH e DELETE
        if (method.localeCompare('GET') === 0) {
            if (permissions.canRead == 0) return JSON.stringify({ status: 403, message: 'Sem permissão de Leitura!' });
        } else if (method.localeCompare('POST') === 0) {
            if (permissions.canCreate == 0) return JSON.stringify({ status: 403, message: 'Sem permissão de Gravação!' });
        } else if (method.localeCompare('PUT') === 0 || method.localeCompare('PATCH') === 0) {
            if (permissions.canUpdate == 0) return JSON.stringify({ status: 403, message: 'Sem permissão de Alteração!' });
        } else if (method.localeCompare('DELETE') === 0) {
            if (permissions.canDelete == 0) return JSON.stringify({ status: 403, message: 'Sem permissão de Exclusão!' });
        }

        //sails.log(userCurrent);
        //sails.log(permissions);

        return JSON.stringify({ status: 200, message: 'Permissão concedida!' });
    }
};