const rp = require('request-promise')
const cheerio = require('cheerio')

const options = {
    uri: 'https://www.fundsexplorer.com.br/ranking',
    transform: function (body) {
        return cheerio.load(body)
    }
}

module.exports = {

    getDatafii: async function () {

        let lastRow = await FII.find()
            .sort('id DESC')
            .limit(1)
        // idReference = 1;

        // //adicionar 1 no último valor da referencia
        // if (lastRow[0] != undefined)
        //     idReference = ++lastRow[0].idReference;

        let fiis = [];

        await rp(options)
            .then(($) => {
                  
                $('#table-ranking > tbody > tr').each(function (index, tr) {
                    const data = {}

                    $(tr).find('td').each(function (column, td) {
                        switch (column) {
                            case 0:
                                data.ticket = $(td).text();
                                break;
                            case 1:
                                data.sector = $(td).text();
                                break;
                            case 2:
                                data.priceBase = parseFloat($(td).attr('data-order').replace("\n", "").replace(",", "").replace("–", "0"));
                                break;
                            // case 3:
                            //     data.datePayment = $(td).text();
                            //     break;
                            case 4:
                                data.yieldValue = parseFloat($(td).attr('data-valor').replace("\n", "").replace(",", "").replace("–", "0"));
                                break;
                            case 5:
                                data.percentageYield = parseFloat($(td).attr('data-valor').replace("\n", "").replace(",", "").replace("–", "0"));
                                break;
                            // case 6:
                            //     data.note = $(td).text();
                            //     break;
                            default:
                                break;
                        }
                    });
                    fiis.push(data)
                });
              //  sails.log(fiis)
            }).catch((err) => {
                console.log('erro: ');

                console.log(err);
                return err;
            });;

            return fiis;
    }

}